/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.format;

import icyllis.annotations.NotNull;
import icyllis.flexmark.util.format.TrackedOffset;
import icyllis.flexmark.util.sequence.BasedSequence;
import icyllis.flexmark.util.sequence.builder.Seg;
import icyllis.flexmark.util.sequence.builder.tree.BasedOffsetTracker;
import icyllis.flexmark.util.sequence.builder.tree.OffsetInfo;
import icyllis.flexmark.util.sequence.builder.tree.SegmentOffsetTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.UnaryOperator;

public class TrackedOffsetList
implements List<TrackedOffset> {
    public static TrackedOffsetList EMPTY_LIST = new TrackedOffsetList(BasedSequence.NULL, Collections.emptyList());
    @NotNull
    private final BasedSequence myBaseSeq;
    @NotNull
    private final List<TrackedOffset> myTrackedOffsets;
    @NotNull
    private final BasedOffsetTracker myBasedOffsetTracker;

    @NotNull
    public static TrackedOffsetList create(@NotNull BasedSequence baseSeq, @NotNull List<TrackedOffset> trackedOffsets) {
        return trackedOffsets instanceof TrackedOffsetList ? (TrackedOffsetList)trackedOffsets : new TrackedOffsetList(baseSeq, trackedOffsets);
    }

    @NotNull
    public static TrackedOffsetList create(@NotNull BasedSequence baseSeq, @NotNull int[] offsets) {
        ArrayList<TrackedOffset> trackedOffsets = new ArrayList<TrackedOffset>(offsets.length);
        for (int offset : offsets) {
            trackedOffsets.add(TrackedOffset.track(offset));
        }
        return new TrackedOffsetList(baseSeq, trackedOffsets);
    }

    private TrackedOffsetList(@NotNull BasedSequence baseSeq, @NotNull List<TrackedOffset> trackedOffsets) {
        this.myBaseSeq = baseSeq;
        this.myTrackedOffsets = new ArrayList<TrackedOffset>(trackedOffsets);
        this.myTrackedOffsets.sort(Comparator.comparing(TrackedOffset::getOffset));
        ArrayList<Seg> segments = new ArrayList<Seg>(trackedOffsets.size());
        for (TrackedOffset trackedOffset : this.myTrackedOffsets) {
            segments.add(Seg.segOf(trackedOffset.getOffset(), trackedOffset.getOffset() + 1));
        }
        SegmentOffsetTree segmentOffsetTree = SegmentOffsetTree.build(segments, "");
        this.myBasedOffsetTracker = BasedOffsetTracker.create(baseSeq, segmentOffsetTree);
        assert (this.myBasedOffsetTracker.size() == this.myTrackedOffsets.size());
    }

    @NotNull
    public TrackedOffsetList getUnresolvedOffsets() {
        ArrayList<TrackedOffset> unresolved = new ArrayList<TrackedOffset>();
        for (TrackedOffset trackedOffset : this.myTrackedOffsets) {
            if (trackedOffset.isResolved()) continue;
            unresolved.add(trackedOffset);
        }
        return unresolved.isEmpty() ? EMPTY_LIST : new TrackedOffsetList(this.myBaseSeq, unresolved);
    }

    public boolean haveUnresolved() {
        for (TrackedOffset trackedOffset : this.myTrackedOffsets) {
            if (trackedOffset.isResolved()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public BasedSequence getBaseSeq() {
        return this.myBaseSeq;
    }

    @NotNull
    public List<TrackedOffset> getTrackedOffsets() {
        return this.myTrackedOffsets;
    }

    @NotNull
    public BasedOffsetTracker getBasedOffsetTracker() {
        return this.myBasedOffsetTracker;
    }

    @NotNull
    public TrackedOffsetList getTrackedOffsets(int startOffset, int endOffset) {
        OffsetInfo startInfo = this.myBasedOffsetTracker.getOffsetInfo(startOffset, startOffset == endOffset);
        OffsetInfo endInfo = this.myBasedOffsetTracker.getOffsetInfo(endOffset, true);
        int startSeg = startInfo.pos;
        int endSeg = endInfo.pos;
        if (startSeg < 0 && endSeg >= 0) {
            startSeg = 0;
            ++endSeg;
        } else if (startSeg >= 0 && endSeg >= 0) {
            ++endSeg;
        } else {
            return EMPTY_LIST;
        }
        endSeg = Math.min(this.myBasedOffsetTracker.size(), endSeg);
        if (startSeg >= endSeg) {
            return EMPTY_LIST;
        }
        if (this.myTrackedOffsets.get(startSeg).getOffset() < startOffset) {
            ++startSeg;
        }
        if (this.myTrackedOffsets.get(endSeg - 1).getOffset() > endOffset) {
            --endSeg;
        }
        if (startSeg >= endSeg) {
            return EMPTY_LIST;
        }
        return new TrackedOffsetList(this.myBaseSeq, this.myTrackedOffsets.subList(startSeg, endSeg));
    }

    @Override
    public boolean add(TrackedOffset offset) {
        throw new IllegalStateException("Not supported. Immutable list.");
    }

    @Override
    public TrackedOffset set(int index, TrackedOffset element) {
        throw new IllegalStateException("Not supported. Immutable list.");
    }

    @Override
    public void add(int index, TrackedOffset element) {
        throw new IllegalStateException("Not supported. Immutable list.");
    }

    @Override
    public TrackedOffset remove(int index) {
        throw new IllegalStateException("Not supported. Immutable list.");
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends TrackedOffset> c) {
        throw new IllegalStateException("Not supported. Immutable list.");
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends TrackedOffset> c) {
        throw new IllegalStateException("Not supported. Immutable list.");
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new IllegalStateException("Not supported. Immutable list.");
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new IllegalStateException("Not supported. Immutable list.");
    }

    @Override
    public void replaceAll(UnaryOperator<TrackedOffset> operator) {
        throw new IllegalStateException("Not supported. Immutable list.");
    }

    @Override
    public void sort(Comparator<? super TrackedOffset> c) {
        throw new IllegalStateException("Not supported. Immutable list.");
    }

    @Override
    public void clear() {
        throw new IllegalStateException("Not supported. Immutable list.");
    }

    @Override
    public boolean remove(Object o) {
        throw new IllegalStateException("Not supported. Immutable list.");
    }

    @Override
    public int size() {
        return this.myTrackedOffsets.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myTrackedOffsets.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.myTrackedOffsets.contains(o);
    }

    @Override
    @NotNull
    public Iterator<TrackedOffset> iterator() {
        return this.myTrackedOffsets.iterator();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.myTrackedOffsets.toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        return this.myTrackedOffsets.toArray(a);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.myTrackedOffsets.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.myTrackedOffsets.equals(o);
    }

    @Override
    public int hashCode() {
        return this.myTrackedOffsets.hashCode();
    }

    @Override
    public TrackedOffset get(int index) {
        return this.myTrackedOffsets.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.myTrackedOffsets.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.myTrackedOffsets.lastIndexOf(o);
    }

    @Override
    @NotNull
    public ListIterator<TrackedOffset> listIterator() {
        return this.myTrackedOffsets.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<TrackedOffset> listIterator(int index) {
        return this.myTrackedOffsets.listIterator(index);
    }

    @Override
    @NotNull
    public List<TrackedOffset> subList(int fromIndex, int toIndex) {
        return this.myTrackedOffsets.subList(fromIndex, toIndex);
    }

    @Override
    public Spliterator<TrackedOffset> spliterator() {
        return this.myTrackedOffsets.spliterator();
    }
}

